
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   INITFUNC.H - Initialization Function Prototypes
// 
//
//   DESCRIPTION
//
//   Prototypes for the various functions used during receiver initialization.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\INITFUNC.H_V  $
//   
//      Rev 1.15   06 Nov 1998 17:47:12   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 10:26:12   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:04:38   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:19:32   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:24   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

void  alm_age_req     (void);
void  alm_request     (void);
void  eph_request     (void);
void  utc_request     (void);
void  altitude_hold   (short);
void  BIT_tests       (void);
void  cold_start      (void); 
void  static_nav      (void);
void  elev_mask       (void);
void  init_2D         (void);
void  init_height     (void);
void  init_pos_vel    (void);
void  init_time       (void);
void  init_timemark   (void);
void  init_dr         (void);
void  initialize      (short);
void  make_tx_header  (short, short);
void  message_enable  (short, short);
int   ResetReceiver   (short);

